/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.config.gun;

import dev.toma.configuration.config.Configurable;
import dev.toma.gunsrpg.api.common.IJamConfig;
import lib.toma.animations.Easings;
import net.minecraft.item.ItemStack;

public final class JamConfig
implements IJamConfig {
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Smallest possible weapon jam chance"})
    @Configurable.Gui.NumberFormat(value="#.###")
    public float minChance;
    @Configurable
    @Configurable.DecimalRange(min=0.0, max=1.0)
    @Configurable.Comment(value={"Largest possible weapon jam chance"})
    @Configurable.Gui.NumberFormat(value="#.###")
    public float maxChance;
    @Configurable
    @Configurable.Comment(value={"Transformer function for actual jam chance calculations", "See https://easings.net for examples"})
    public Easings jamChanceTransformerFunction;

    public JamConfig(float minChance, float maxChance, Easings easing) {
        this.minChance = minChance;
        this.maxChance = maxChance;
        this.jamChanceTransformerFunction = easing;
    }

    @Override
    public float getJamChance(ItemStack stack) {
        float breakProgress = (float)stack.func_77952_i() / (float)stack.func_77958_k();
        return this.getJamChance(breakProgress);
    }

    @Override
    public float getJamChance(float breakProgress) {
        float progress = this.jamChanceTransformerFunction.ease(breakProgress);
        float diff = this.maxChance - this.minChance;
        return this.minChance + progress * diff;
    }
}

